VERSION 5.00
Begin VB.UserControl SRM_Action 
   ClientHeight    =   10500
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   14925
   ScaleHeight     =   10500
   ScaleWidth      =   14925
   Begin VB.Frame fra_Detail 
      Height          =   9450
      Left            =   15
      TabIndex        =   0
      Top             =   750
      Width           =   14280
      Begin VB.CommandButton cmd_addVendorContact 
         Caption         =   "#Add"
         Height          =   345
         Left            =   6360
         TabIndex        =   8
         Tag             =   "cmd_addVendorContact"
         Top             =   2325
         Width           =   735
      End
      Begin VB.Frame fra_manipulation 
         Caption         =   "#Manipulation"
         Height          =   1590
         Left            =   7410
         TabIndex        =   26
         Tag             =   "frm_maintenance"
         Top             =   1080
         Width           =   6570
         Begin VB.TextBox txt_date 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   1740
            TabIndex        =   32
            Tag             =   "txt_Date"
            Text            =   "02/02/2001"
            Top             =   322
            Width           =   1095
         End
         Begin VB.TextBox txt_creator 
            Enabled         =   0   'False
            Height          =   330
            Left            =   3870
            TabIndex        =   31
            Tag             =   "txt_creator"
            Text            =   "L. Cockayne"
            Top             =   322
            Width           =   2415
         End
         Begin VB.TextBox txt_lastUpd 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   1740
            TabIndex        =   30
            Tag             =   "txt_lastUpd"
            Text            =   "02/02/2001"
            Top             =   742
            Width           =   1095
         End
         Begin VB.TextBox txt_updUser 
            Enabled         =   0   'False
            Height          =   330
            Left            =   3870
            TabIndex        =   29
            Tag             =   "txt_updUser"
            Text            =   "L. Cockayne"
            Top             =   742
            Width           =   2415
         End
         Begin VB.TextBox txt_dropDate 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   330
            Left            =   1740
            TabIndex        =   28
            Tag             =   "txt_dropDate"
            Text            =   "02/02/2001"
            Top             =   1132
            Width           =   1095
         End
         Begin VB.CheckBox chk_dropped 
            Caption         =   "#Dropped"
            Height          =   255
            Left            =   3870
            TabIndex        =   27
            Tag             =   "chk_dropped"
            Top             =   1170
            Width           =   1515
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#Creation date"
            Height          =   255
            Index           =   11
            Left            =   150
            TabIndex        =   37
            Tag             =   "lbl_date"
            Top             =   360
            Width           =   1530
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#By"
            Height          =   255
            Index           =   12
            Left            =   3150
            TabIndex        =   36
            Tag             =   "lbl_By"
            Top             =   360
            Width           =   690
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#Last updade"
            Height          =   255
            Index           =   13
            Left            =   150
            TabIndex        =   35
            Tag             =   "lbl_dateUpd"
            Top             =   780
            Width           =   1530
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#By"
            Height          =   255
            Index           =   14
            Left            =   3150
            TabIndex        =   34
            Tag             =   "lbl_By"
            Top             =   720
            Width           =   690
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#Drop date"
            Height          =   255
            Index           =   15
            Left            =   150
            TabIndex        =   33
            Tag             =   "lbl_dropDate"
            Top             =   1170
            Width           =   1530
         End
      End
      Begin VB.TextBox txt_Key 
         Height          =   330
         Left            =   12195
         TabIndex        =   2
         Top             =   270
         Width           =   1785
      End
      Begin VB.TextBox txt_Summary 
         Height          =   330
         Left            =   2025
         TabIndex        =   5
         Top             =   1485
         Width           =   4230
      End
      Begin VB.TextBox txt_Plant 
         Height          =   345
         Left            =   2025
         TabIndex        =   3
         Top             =   720
         Width           =   4230
      End
      Begin VB.TextBox txt_Description 
         Height          =   2940
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   9
         Top             =   3270
         Width           =   6735
      End
      Begin VB.TextBox txt_PrevAction 
         Height          =   2580
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   12
         Top             =   6690
         Width           =   6735
      End
      Begin VB.TextBox txt_Comment 
         Height          =   2580
         Left            =   7245
         MaxLength       =   1000
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   13
         Top             =   6690
         Width           =   6735
      End
      Begin VB.Frame fra_Attachment 
         Caption         =   "#Attachments"
         Height          =   3225
         Left            =   7200
         TabIndex        =   18
         Tag             =   "fra_Attachments"
         Top             =   2910
         Width           =   6735
         Begin Project1.ToolbarControl tlb_Attachment 
            Height          =   2850
            Left            =   5880
            TabIndex        =   11
            Top             =   240
            Width           =   690
            _ExtentX        =   1217
            _ExtentY        =   5027
         End
         Begin Project1.ArmGrid grd_Attachment 
            Height          =   2850
            Left            =   60
            TabIndex        =   10
            Tag             =   "grd_Attachment"
            Top             =   270
            Width           =   5700
            _ExtentX        =   10054
            _ExtentY        =   5027
         End
      End
      Begin VB.TextBox txt_Reference 
         Height          =   345
         Left            =   2025
         TabIndex        =   1
         Top             =   285
         Width           =   4230
      End
      Begin Project1.ArmCombobox cbo_VenContact 
         Height          =   345
         Left            =   2025
         TabIndex        =   7
         Top             =   2340
         Width           =   4230
         _ExtentX        =   7461
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_Status 
         Height          =   345
         Left            =   2025
         TabIndex        =   6
         Top             =   1905
         Width           =   4230
         _ExtentX        =   7461
         _ExtentY        =   609
      End
      Begin Project1.ArmPicker pck_operator 
         Height          =   300
         Left            =   2025
         TabIndex        =   4
         Top             =   1140
         Width           =   4230
         _ExtentX        =   7461
         _ExtentY        =   529
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#ID"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   11
         Left            =   10425
         TabIndex        =   25
         Tag             =   "lbl_ID"
         Top             =   345
         Width           =   1725
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Status"
         Height          =   255
         Index           =   7
         Left            =   120
         TabIndex        =   24
         Tag             =   "lbl_Status"
         Top             =   1935
         Width           =   1725
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Summary"
         Height          =   225
         Index           =   6
         Left            =   120
         TabIndex        =   23
         Tag             =   "lbl_Summary"
         Top             =   1515
         Width           =   1725
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Vendor contact"
         Height          =   255
         Index           =   8
         Left            =   120
         TabIndex        =   22
         Tag             =   "lbl_VendorContact"
         Top             =   2370
         Width           =   1725
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Description"
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   21
         Tag             =   "lbl_Description"
         Top             =   2910
         Width           =   2220
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Previous action"
         Height          =   255
         Index           =   3
         Left            =   120
         TabIndex        =   20
         Tag             =   "lbl_PreviousAction"
         Top             =   6360
         Width           =   2220
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Comments"
         Height          =   255
         Index           =   10
         Left            =   7230
         TabIndex        =   19
         Tag             =   "lbl_Comments"
         Top             =   6360
         Width           =   2220
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Operator"
         Height          =   225
         Index           =   0
         Left            =   120
         TabIndex        =   17
         Tag             =   "lbl_Operator"
         Top             =   1170
         Width           =   1725
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Plant"
         Height          =   225
         Index           =   1
         Left            =   120
         TabIndex        =   15
         Tag             =   "lbl_Plant"
         Top             =   810
         Width           =   1725
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Reference "
         Height          =   225
         Index           =   2
         Left            =   120
         TabIndex        =   14
         Tag             =   "lbl_Reference"
         Top             =   360
         Width           =   1725
      End
   End
   Begin Project1.ToolbarControl tlb_main 
      Height          =   690
      Left            =   0
      TabIndex        =   16
      Top             =   0
      Width           =   6885
      _ExtentX        =   12144
      _ExtentY        =   1217
   End
End
Attribute VB_Name = "SRM_Action"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' **************************************************************************************************
' ************************************* EXTERNAL DECLARATIONS **************************************
' **************************************************************************************************
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
' **************************************************************************************************

' **************************************************************************************************
' **************************************** TOOL CONSTANTS ******************************************
' **************************************************************************************************
Private Const LOCALE_USER_DEFAULT = &H400
Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2
Private Const C_APPNAME As String = "SRM_ACTION"              ' for error log
Private Const C_SCREENNAME As String = "SRM_Action"           ' for loading screen constants
Private Const C_SCREENMODE_STACK_SIZE As Long = 5           ' size of stack for active screens
Private Const C_TOOLBARFACE_ITEM_VIEW As String = "0"
Private Const C_TOOLBARFACE_ITEM_ADD As String = "1"
Private Const C_TOOLBARFACE_ITEM_UPD As String = "2"
Private Const C_TOOLBARFACE_ITEM_DEL As String = "3"
Private Const SIFYB_CM_ERROR_MESSAGE = 2400                 ' const for base of error messages ids
' ****************************************** TOOL CONSTANTS ***************************************

' **************************************************************************************************
' **************************************** USER DEFINED ERRORS *************************************
' **************************************************************************************************
Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    CompFncFailed = vbObjectError + 6           ' when component function fail
    QuietException = vbObjectError + 7          ' do not display error message
    WarMsgSelectRow = vbObjectError + 8
    SQLBadRowAffectedCount = vbObjectError + 9  ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 10 ' A SQL request does not return the expected rowcount : select an item return nothing...
End Enum

Private Enum ErrMsg
    ErrMsgNone = 0
    ErrMsgMandatoryAreEmpty = SIFYB_CM_ERROR_MESSAGE + 1
    ErrMsgDuplicateOrder = SIFYB_CM_ERROR_MESSAGE + 2
    ErrMsgDuplicateLevel = SIFYB_CM_ERROR_MESSAGE + 3
    ErrMsgMissingLevel = SIFYB_CM_ERROR_MESSAGE + 4
    ErrMsgNumericRequired = SIFYB_CM_ERROR_MESSAGE + 5
    ErrMsgItemIsDeleted = SIFYB_CM_ERROR_MESSAGE + 19
End Enum

' *************************************** USER DEFINED ERRORS **************************************

' **************************************************************************************************
' *************************************** CONTROL MEMBERS ******************************************
' **************************************************************************************************
Dim ml_U_Code As Long                   ' if this is user loging app, needed to log errors into A_Log
Dim ms_LoginName As String
Dim ms_Language_Code As String
Dim mb_Initialized As Boolean           ' True if the component is already initialized
Dim mb_Initializing As Boolean          ' Flag of initializing
Dim mua_ActiveMode() As ArmScreenMode
Dim ms_Title As String                  ' title of user control - can be assigned as Caption to the parent form or title for printing
Dim ms_DecimalSeparator As String       ' decimal separator obtained from local settings
Dim ms_ThousandSeparator As String      'locale thousand separator
Dim moa_ListFieldsMandatory As Variant  ' all mandatory controls
Dim moa_ListFieldsToDisable() As Control            ' common disabled control
Dim mo_dataSrc As Dictionary            ' for item restore purpose
Dim ms_oldOperatorCode As String        ' old operator code
Dim ms_oldOperatorDesc As String        ' old operator desccription

Dim ms_UserAssignedEmail As String      ' U_Email_Armstrong - task 464


Private WithEvents mo_SRM_Attachment    As SRM_Attachment
Attribute mo_SRM_Attachment.VB_VarHelpID = -1
Private WithEvents mo_SRM_VendorContact As SRM_VenContact
Attribute mo_SRM_VendorContact.VB_VarHelpID = -1

Private Enum ArmScreenMode
    smRefreshOnly
    smMain
    smAdd
    smUpdate
    smDelete
    smView
    smSubAttachement
    smSubVendorContact
End Enum


#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

' *************************************** CONTROL MEMBERS ******************************************
Public Event OnExit()
Public Event OnItemAdd(ByVal as_SrzFields As String)
Public Event OnItemUpdate(ByVal as_SrzFields As String, ByVal as_from As String, ByRef ab_retVal As Boolean)
Public Event OnItemDelete(ByVal av_Key As Variant)
Public Event OnItemNext()
Public Event OnItemPrevious()
Public Event GetNextFreeID(ByRef as_nextID As String)


' **************************************************************************************************
' **************************************************************************************************
' **************************************************************************************************


' mb_Initialized is a read-only property, indicates the status of the component
Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub
Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property
Public Sub Zorder()
  Call UserControl.Extender.Zorder
End Sub
Public Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ml_U_Code = al_U_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".U_Code(Let)")
End Property

Public Property Let LoginName(ByVal as_LoginName As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ms_LoginName = as_LoginName
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LoginName(Let)")
End Property

Public Property Let Language_Code(as_Language_Code As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If Len(as_Language_Code) <> 1 Then Call Err.Raise(ArmErr.InvalidArgument, "", "Language_code must contains only 1 char")
    
    ms_Language_Code = as_Language_Code
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Language(Let)")
End Property

Public Property Set DB(ByRef ao_DB As ArmDb)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If ao_DB Is Nothing Then Call Err.Raise(ArmErr.InvalidArgument)
    
    Set mo_Db = ao_DB
    Exit Property
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Db(Set)")
End Property

Public Property Get Title() As String
    Title = ms_Title
End Property

Public Sub Run(ByVal ae_ScrMode As SRM_Mode, ByVal as_SrzFields As String)
On Error GoTo ErrHandler

    Debug.Assert (mb_Initialized = True)
    
    Call LockScreen(True)       'JN: i am not sure if this is necessary if called from other control which already locked the screen
    
    Call FillDataSrcArray(mo_dataSrc, as_SrzFields)
    
    Select Case ae_ScrMode
        Case SRM_Mode.emView
            Call Item_ViewInit(mo_dataSrc)
        Case SRM_Mode.emAdd
            Call Item_AddInit(mo_dataSrc)
        Case SRM_Mode.emUpdate
            Call Item_UpdateInit(mo_dataSrc)
        Case SRM_Mode.emDelete
            Call Item_DeleteInit(mo_dataSrc)
            
    End Select
    
    Call LockScreen(False)
    
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".Run")
End Sub

Public Sub Load_A_COM()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If mo_Db Is Nothing Then Call Err.Raise(ArmErr.PropertyNotSet, "", "mo_Db")
    If Len(ms_Language_Code) < 1 Then Call Err.Raise(ArmErr.PropertyNotSet, "", "ms_Language_Code")

    ' get decimal separator for conversion from string to double
    ms_DecimalSeparator = Format(0, ".")
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If

    ' Set Db
    ' Call Load_A_Com
    ' Initialize toolbars
    Debug.Assert (Not mo_Db Is Nothing)
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.Load_A_COM
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    
    ReDim Preserve mua_ActiveMode(0)
    mua_ActiveMode(UBound(mua_ActiveMode)) = ArmScreenMode.smMain
    
    Set mo_dataSrc = New Dictionary
    mo_dataSrc.CompareMode = TextCompare

    ' init controls
    Call Components_Settings
    
    ReDim moa_ListFieldsMandatory(0 To 2)
    moa_ListFieldsMandatory(0) = Array(cbo_Status, 7)
    moa_ListFieldsMandatory(1) = Array(txt_Comment, 10)
    moa_ListFieldsMandatory(2) = Array(pck_operator, 0)
    
    InitMandatoryLabels (moa_ListFieldsMandatory)
     
    Call FillControlArray(moa_ListFieldsToDisable, Array(txt_Key, txt_Reference, txt_Plant, txt_Summary, txt_PrevAction, txt_Description, txt_Date, txt_creator, txt_lastUpd, txt_updUser, txt_dropDate, chk_dropped))
    
    Call InitComponents
    
    Call LoadLabels(UserControl.Controls, C_SCREENNAME, ms_Language_Code)
    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    
    ' set layout
    Call InitCtrlSize
    
    mb_Initialized = True

    ' display starting face
    Call UpdateUI(ArmScreenMode.smMain)
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Load_A_Com()")
End Sub

Private Sub FillControlArray(ByRef ao_ctrlArray() As Control, ByRef ao_array As Variant)
On Error GoTo ErrHandler
    Dim ll_i As Long
    If Not IsArray(ao_array) Then
        Exit Sub
    End If
    
    ReDim ao_ctrlArray(LBound(ao_array) To UBound(ao_array)) As Control
    
    For ll_i = LBound(ao_array) To UBound(ao_array)
        Set ao_ctrlArray(ll_i) = ao_array(ll_i)
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".FillControlArray()")
End Sub

Public Sub Unload_A_COM()
Dim lo_Control As Object
On Error GoTo ErrHandler
    If Not Initialized Then Call Err.Raise(ArmErr.CPTNotInitialized)
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER"
            Call lo_Control.Unload_A_COM
        End Select
    Next
    If Not mo_SRM_Attachment Is Nothing Then
        Call mo_SRM_Attachment.Unload_A_COM
        Set mo_SRM_Attachment = Nothing
    End If
    If Not mo_SRM_VendorContact Is Nothing Then
        Call mo_SRM_VendorContact.Unload_A_COM
        Set mo_SRM_VendorContact = Nothing
    End If
    
    Set mo_Db = Nothing
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".Unload_A_Com()")
End Sub

Private Sub Components_Settings()
On Error GoTo ErrHandler

    Call Component_SetUp(txt_Key, "SRA_Id" & SEP & "Text")

    Call Component_SetUp(cbo_Status, "SRAS_Id" & SEP & "SRAS_Desc")
    Call Component_SetUp(cbo_VenContact, "SVC_Id" & SEP & "VC_Name")

    Call Component_SetUp(txt_Reference, "SRT_Id" & SEP & "Num")
    Call Component_SetUp(txt_Plant, "MFGP_Name" & SEP & "Text")
    Call Component_SetUp(pck_operator, "User_Assigned" & SEP & "User_Assigned_Name")
    Call Component_SetUp(txt_Summary, "SRT_Summary" & SEP & "Text")
    Call Component_SetUp(txt_Description, "SRT_Description" & SEP & "Text")
    Call Component_SetUp(txt_Comment, "SRA_Comment" & SEP & "Text")
    Call Component_SetUp(txt_PrevAction, "PrevActionComment" & SEP & "Text")

    ' system controls
    Call Component_SetUp(txt_Date, "Z_Creation" & SEP & "Date")
    Call Component_SetUp(txt_lastUpd, "Z_Last_Upd" & SEP & "Date")
    Call Component_SetUp(txt_dropDate, "Drop_Date" & SEP & "Date")
    Call Component_SetUp(txt_creator, "Z_Creator_Name" & SEP & "Text")
    Call Component_SetUp(txt_updUser, "Z_Last_Upd_User_Name" & SEP & "Text")
    Call Component_SetUp(chk_dropped, "Drop_flag")

    Exit Sub
ErrHandler:
    Call ErrorHandler("Components_Settings")
End Sub

Private Sub Component_SetUp(ByVal ao_cpt As Object, ByVal as_Tag As String)

On Error GoTo ErrHandler
    
    ao_cpt.Tag = as_Tag
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Component_SetUp")
End Sub

Private Sub InitTaskAttachment()
On Error GoTo ErrHandler
    If mo_SRM_Attachment Is Nothing Then
        Set mo_SRM_Attachment = UserControl.Controls.Add(SRM_C_ProgID & ".SRM_Attachment", "mo_SRM_Attachment", Me)
        mo_SRM_Attachment.Visible = False
        Call mo_SRM_Attachment.Move(0, 0, Extender.Width, Extender.Height)
        
        mo_SRM_Attachment.Language_Code = ms_Language_Code
        mo_SRM_Attachment.U_Code = ml_U_Code
        mo_SRM_Attachment.LoginName = ms_LoginName
        Set mo_SRM_Attachment.DB = mo_Db
        
        Call mo_SRM_Attachment.Load_A_COM
        If Not mo_SRM_Attachment.Initialized Then
            Call Err.Raise(ArmErr.CompFncFailed, "mo_SRM_Attachment.Initialized", "SRM_Attachment cannot was not initialised")
        End If
        mo_SRM_Attachment.Zorder
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InitTaskAttachment")
End Sub

Private Sub InitVendorContact()
On Error GoTo ErrHandler
    If mo_SRM_VendorContact Is Nothing Then
        Set mo_SRM_VendorContact = UserControl.Controls.Add(SRM_C_ProgID & ".SRM_VenContact", "mo_SRM_VendorContact", Me)
        mo_SRM_VendorContact.Visible = False
        Call mo_SRM_VendorContact.Move(0, 0, Extender.Width, Extender.Height)
        
        mo_SRM_VendorContact.Language_Code = ms_Language_Code
        mo_SRM_VendorContact.U_Code = ml_U_Code
        mo_SRM_VendorContact.LoginName = ms_LoginName
        Set mo_SRM_VendorContact.DB = mo_Db
        
        Call mo_SRM_VendorContact.Load_A_COM
        If Not mo_SRM_VendorContact.Initialized Then
            Call Err.Raise(ArmErr.CompFncFailed, "mo_SRM_VendorContact.Initialized", "mo_SRM_VendorContact cannot was not initialised")
        End If
        mo_SRM_VendorContact.Zorder
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InitVendorContact")
End Sub


Private Sub UpdateUI(Optional ByVal au_Mode As ArmScreenMode = ArmScreenMode.smRefreshOnly)
On Error GoTo ErrHandler

    ' set active face
    If au_Mode <> smRefreshOnly Then
        If UBound(mua_ActiveMode) = C_SCREENMODE_STACK_SIZE - 1 Then
            ' move array left
            Debug.Print ("Stack is too small. Increase C_SCREENMODE_STACK_SIZE constant please.")
            Dim ll_Index As Long
            For ll_Index = 1 To UBound(mua_ActiveMode)
                mua_ActiveMode(ll_Index - 1) = mua_ActiveMode(ll_Index)
            Next
        Else
            ' allocate one more item
            ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) + 1)
        End If
        mua_ActiveMode(UBound(mua_ActiveMode)) = au_Mode
    End If

    tlb_Main.Redraw = False

    ' hide all frames
    fra_detail.Visible = False
    tlb_Main.Visible = False

    ' we have clean screen we can display proper controls
    Select Case activeScreenMode
        Case smMain
        Case smAdd
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_ADD)
            tlb_Attachment.Visible = True
            Call tlb_Attachment.DisplayFace("0")
        Case smUpdate
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_UPD)
            tlb_Attachment.Visible = True
            Call tlb_Attachment.DisplayFace("0")
        Case smView
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_VIEW)
            tlb_Attachment.Visible = False
        Case smDelete
            fra_detail.Visible = True
            tlb_Main.Visible = True
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_DEL)
            tlb_Attachment.Visible = False
        Case Else
            Debug.Assert (False)
    End Select
    
    ' todo:apply rights on toolbar
    Call UpdateMainToolbar

    tlb_Main.Redraw = True

    ' to display face immidiatelly
    UserControl.Refresh
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".UpdateUI()")
End Sub

Private Function UpdateUISubDetail(Optional ByVal au_Mode As ArmScreenMode = ArmScreenMode.smRefreshOnly) As ArmScreenMode
On Error GoTo ErrHandler
    Static lu_lastScreen As ArmScreenMode
    
    If au_Mode = smRefreshOnly Then au_Mode = lu_lastScreen

    fra_detail.Visible = False
    tlb_Main.Visible = False
    If Not mo_SRM_Attachment Is Nothing Then mo_SRM_Attachment.Visible = False
    If Not mo_SRM_VendorContact Is Nothing Then mo_SRM_VendorContact.Visible = False

    Select Case au_Mode
        Case smMain
            fra_detail.Visible = True
            tlb_Main.Visible = True
        Case smSubAttachement
            If Not mo_SRM_Attachment Is Nothing Then mo_SRM_Attachment.Visible = True
        Case smSubVendorContact
            If Not mo_SRM_VendorContact Is Nothing Then mo_SRM_VendorContact.Visible = True
        Case Else
            Debug.Assert (False)
    End Select
    
    UpdateUISubDetail = lu_lastScreen
    lu_lastScreen = au_Mode
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".UpdateUISubDetail")
End Function

' ************************************************************************************
' **************************** FRAMEWORK FUNCTIONS ***********************************
' ************************************************************************************

Private Property Get activeScreenMode(Optional ByVal al_fromTop As Long = 0) As ArmScreenMode
On Error GoTo ErrHandler
    Debug.Assert (IsArray(mua_ActiveMode))
    activeScreenMode = mua_ActiveMode(UBound(mua_ActiveMode) - al_fromTop)
    Exit Property
ErrHandler:
     Call ErrorHandler(Extender.Name & ".activeScreenMode(Get)")
End Property

Private Sub popScreenMode()
On Error GoTo ErrHandler
    Debug.Assert (UBound(mua_ActiveMode) >= 1)
    ReDim Preserve mua_ActiveMode(UBound(mua_ActiveMode) - 1)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenMode")
End Sub

Private Sub popScreenModeUntil(ByVal ae_goTo As ArmScreenMode)
On Error GoTo ErrHandler
    While activeScreenMode <> ae_goTo
        Call popScreenMode
    Wend
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".popScreenModeUntil")
End Sub


Private Sub InitComponents()
'Const CL_REQUEST_TB As String = "SELECT Info FROM Toolbars_Definitions WHERE ID=$id$"
Const CL_REQUEST_TB As String = "A_ToolbarDef_sel 1, 2421, 2809, $id$"

On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    Dim ll_cursor As Long
    Dim ll_i As Long
    
    ' main toolbar
    ll_cursor = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$id$", "NULL"))
    If mo_Db.Find(ll_cursor, "id", TLB_SRM_ACTION_ID) >= 0 Then
        Call tlb_Main.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_cursor, "info"), Left(mo_Db.GetFields(ll_cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_SRM_ACTION_ID & ") not found in DB")
    End If

    ' attachment sub toolbar
    If mo_Db.Find(ll_cursor, "id", TLB_SRM_ACTION_SUB_ATTACHMENTS_ID) >= 0 Then
        Call tlb_Attachment.SetToolbarInfoStringParameters(mo_Db.GetFields(ll_cursor, "info"), Left(mo_Db.GetFields(ll_cursor, "info"), 3))
    Else
        Call Err.Raise(ArmErr.InvalidArgument, "mo_Db.Find", "Toolbar id(" & TLB_SRM_ACTION_SUB_ATTACHMENTS_ID & ") not found in DB")
    End If
    
    Call mo_Db.Close(ll_cursor)
    ll_cursor = 0
    
    cbo_VenContact.FirstBlankItem = True
    cbo_VenContact.Request = ""
    
    cbo_Status.FirstBlankItem = False
    cbo_Status.Request = ReplaceCommonPlaceholders(REQ_SELECT_ACTION_STATUS_CBO)
    
    Call grd_Attachment.SetColumns(Array( _
          Join(Array("SRAA_Id", 0, 1, "SRAA_Id", ""), SEP) _
        , Join(Array("SAL_Desc", 1000, 0, "SAL_Desc", "#Description", "String", "", "Left"), SEP) _
        , Join(Array("P_Name", 1500, 0, "P_Name", "#User", "String", "", "Left"), SEP) _
        , Join(Array("Z_Creation", 1500, 0, "Z_Creation", "#Date", "Date", "", "Left"), SEP) _
        , Join(Array("iConcurrency", 0, 0, "iConcurrency", "", "Number", "", "Left"), SEP) _
        , Join(Array("change", 0, 0, "change", "", "String", "", "Left"), SEP) _
        ))

    Exit Sub
ErrHandler:
    If ll_cursor <> 0 Then
        Call mo_Db.Close(ll_cursor)
        ll_cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".InitComponents()")
End Sub

Private Sub InitMandatoryLabels(ByRef av_ListFieldsMandatory As Variant)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim lo_Label As Label

    For ll_Index = 0 To UBound(av_ListFieldsMandatory)
        If av_ListFieldsMandatory(ll_Index)(1) >= 0 Then
            Set lo_Label = lbl_Label(av_ListFieldsMandatory(ll_Index)(1))
            lo_Label.FontBold = True
        End If
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("InitMandatoryLabels")
End Sub

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = ReplacePlaceHolder(as_Request, "$language_code$", SQLStr(ms_Language_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Creator$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$U_Code$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Last_Upd_User$", SqlInt(ml_U_Code))
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplaceCommonPlaceholders")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    ReplacePlaceHolder = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplacePlaceholder")
End Function
Private Sub InitCtrlSize()
On Error GoTo ErrHandler
Const c_margin As Long = 60
    ' ??????????
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InitCtrlSize()")
End Sub

Private Sub LoadDataToForm(ByRef as_detailData As Dictionary, ByRef aControls As Variant, ByRef aContainer As Object)
On Error GoTo ErrHandler
   
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    Dim lValues As Variant
    Dim ls_TempTag As String
    
        lCount = aControls.Count - 1
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                Select Case UCase(TypeName(lControl))
                    Case "TEXTBOX"
                            ls_TempTag = lControl.Tag & SEP
                            lValues = Split(ls_TempTag, SEP)
                            If as_detailData.Exists(lValues(0)) Then
                                Select Case lValues(1)
                                    Case "Text"
                                        lControl.Text = as_detailData(lValues(0))
                                    Case "Num"
                                        lControl.Text = Replace(as_detailData(lValues(0)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                    Case "Date"
                                        If as_detailData(lValues(0)) = "00:00:00" Or as_detailData(lValues(0)) = "" Then
                                            lControl.Text = ""
                                        Else
                                            lControl.Text = Format(as_detailData(lValues(0)), "dd\/mm\/yyyy")
                                        End If
                                End Select
                            End If
                    
                    Case "ARMCOMBOBOX"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If as_detailData.Exists(lValues(0)) Then
                            If as_detailData(lValues(0)) = 0 Or as_detailData(lValues(0)) = "" Then
                                Set lControl.SelectedItem = Nothing
                            Else
                                If lControl.SearchItem(as_detailData(lValues(0)), 0, 0, True) = False Then
                                    If lControl.AddItem(Array(as_detailData(lValues(0)), as_detailData(lValues(1))), True) Is Nothing Then
                                        Err.Raise 2222, "", ""
                                    End If
                                End If
                            End If
                        End If
                        
                    Case "OPTIONBUTTON"
                        lValues = Split(lControl.Tag, SEP)
                        If as_detailData.Exists(lValues(0)) Then
                            If UCase(lValues(2)) Like UCase(as_detailData(lValues(0))) Then
                                lControl.Value = True
                            End If
                        End If
                        
                    Case "CHECKBOX"
                        If as_detailData.Exists(lControl.Tag) Then
                            If UCase(as_detailData(lControl.Tag)) Like "X" Then
                                lControl.Value = vbChecked
                            Else
                                lControl.Value = vbUnchecked
                            End If
                        End If
                        
                    Case "A_CALOCX"
                        lControl.date_courte = as_detailData(lControl.Tag)
                        
                    Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL"
                        'Do Nothing
                    
                    Case "ARMGRID"
                        ' LOAD GRID
                    Case "ARMPICKER"
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If as_detailData.Exists(lValues(0)) Then
                            lControl.ItemCode = as_detailData(lValues(0))
                            lControl.ItemDescription = as_detailData(lValues(1))
                            If lControl.ItemCode = "0" And lControl.ItemDescription = "" Then lControl.ItemCode = ""
                        End If
                    
                    Case Else
                        Debug.Print "LoadDataToForm  -> " & UCase(TypeName(lControl))
                End Select
            End If
            Set lControl = Nothing
        Next

    Exit Sub

ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("LoadDataToForm")

End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo ErrHandler

    Dim lIdx As Long, lCount As Long, lLabels As Long
    Dim lControl As Control
    
    lLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    Debug.Assert (lLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "MENU", "CHECKBOX"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                        ' once translation is done and control is not in array CLEAR tag
                        If Not TypeOf lControl Is Frame And Not TypeOf lControl Is Label Then
                            lControl.Tag = ""
                        End If
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                      Call lControl.LoadConstants(ptStatic, mo_Db.GetFields(lLabels, "LOCAL_TEXT"), ctColumns)
                    End If
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag & "_Title", , 1) >= 0 Then
                      lControl.Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "TABSTRIP"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim lsa_TextArr() As String
                        Dim ll_Index As Long
                        
                        lsa_TextArr = Split(mo_Db.GetFields(lLabels, "LOCAL_TEXT"), SEP)
                        
                        For ll_Index = LBound(lsa_TextArr, 1) To UBound(lsa_TextArr, 1)
                            lControl.Tabs(ll_Index + 1).Caption = lsa_TextArr(ll_Index)
                        Next
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "COMMANDBUTTON", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    ' SPECIAL INITIALIZATION
    ' Title
    If mo_Db.Find(lLabels, "FIELD_NAME", "title", , 1) >= 0 Then
        ms_Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
    End If

    Call mo_Db.Close(lLabels)

    Exit Sub

ErrHandler:
    If lLabels > 0 Then
        Call mo_Db.Close(lLabels)
    End If
    Call ErrorHandler(Extender.Name & ".LoadLabels")
End Sub

Private Function GetContainedControlsChain(ByVal ao_parent As Object) As Collection
On Error GoTo ErrHandler
    Dim lo_retCollection As New Collection
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        If Not TypeOf lo_Control.Container Is SRM_Action Then
            If ao_parent.hwnd = lo_Control.Container.hwnd Then
                If TypeOf lo_Control Is Frame Then
                    Dim lo_aux_collection As New Collection
                    Dim ll_i As Long
                    Set lo_aux_collection = GetContainedControlsChain(lo_Control)
                    For ll_i = 1 To lo_aux_collection.Count
                        lo_retCollection.Add (lo_aux_collection.Item(ll_i))
                    Next
                Else
                    Call lo_retCollection.Add(lo_Control)
                End If
            End If
        End If
    Next
    Set GetContainedControlsChain = lo_retCollection
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetContainedControlsChain()")
End Function

' as_Name equals to Tag definition string

Private Function GetControl(ByVal ao_array As Object, ByVal as_Name As String) As Object
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_array
        If StrComp(lo_ctrl.Tag, as_Name, vbTextCompare) = 0 Then
            Set GetControl = lo_ctrl
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetControl()")
End Function

Private Sub SetEnabled(ByVal ao_srcCtrl As Object, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_srcCtrl
        Call SetEnabledCtrl(lo_ctrl, ab_Value)
    Next
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabled()")
End Sub

Private Sub SetEnabledCtrl(ByRef ao_ctrl As Control, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
        Select Case UCase(TypeName(ao_ctrl))
        Case "TEXTBOX"
            ao_ctrl.Locked = Not ab_Value
            ao_ctrl.BackColor = IIf(ab_Value, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
        Case "TABSTRIP", "A_CALOCX", "ARMGRID", "ARMCOMBOBOX", "FRAME", "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX", "OPTIONBUTTON", "ARMTREEVIEW", "COMMANDBUTTON", "PICTUREBOX", "CHECKBOX", "IMAGECOMBO"
            ao_ctrl.Enabled = ab_Value
        End Select
    Exit Sub
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SetEnabledCtrl()")
End Sub


' loads values from cursor into form. if cursor=0 then reset whole detail
Private Sub Item_LoadValues(ByRef as_detailData As Dictionary)
On Error GoTo ErrHandler
    Dim ls_req As String
    mb_Initializing = True
    
    ' init cbo_product
    If as_detailData.Exists("SV_Id") Then
        ls_req = ReplacePlaceHolder(REQ_SELECT_CONTACTVENDORLINK_CBO, "$SV_Id$", SqlInt(as_detailData("SV_Id")))
        cbo_VenContact.Request = ReplaceCommonPlaceholders(ls_req)
    Else
        ' item cbo_product should be locked in this case / view or delete screen
        cbo_VenContact.Request = ""
    End If
    
    
    ' load main record
    Call LoadDataToForm(as_detailData, UserControl.Controls, Me)
    
    ' remember old operator:
    ms_oldOperatorCode = pck_operator.ItemCode
    ms_oldOperatorDesc = pck_operator.ItemDescription
    
    ' remember U_Email_Armstrong for assigned user
    ms_UserAssignedEmail = as_detailData("U_Email_Armstrong")
    
    mb_Initializing = False

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_LoadValues")
End Sub


' clear all controls values
Private Sub Item_Clear()
On Error GoTo ErrHandler
    mb_Initializing = True
    Call ClearForm(UserControl.Controls, fra_detail, Array(grd_Attachment))
    mb_Initializing = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Clear")
End Sub

' initialize view mode
Private Sub Item_ViewInit(ByRef as_detailData As Dictionary)
On Error GoTo ErrHandler
    
    Call ResetScreen(ArmScreenMode.smView)
    Call Item_Clear
    
    ' loading values
    Call Item_LoadValues(as_detailData)
    
    Call UpdateUI(ArmScreenMode.smView)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ViewInit")
End Sub

' initialize delete mode
Private Sub Item_DeleteInit(ByRef ao_detailData As Dictionary)
On Error GoTo ErrHandler
    
    Call ResetScreen(ArmScreenMode.smDelete)
    Call Item_Clear

    ao_detailData("change") = "D"

    Call Item_LoadValues(ao_detailData)
    
    Call UpdateUI(ArmScreenMode.smDelete)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_DeleteInit")
End Sub


' initialize update mode
Private Sub Item_AddInit(ByRef ao_detailData As Dictionary)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smAdd)
    Call Item_Clear
    
    If ao_detailData.Exists("Z_Creation") Then
        ao_detailData("Z_Creation") = Format(Now, "DD/MM/YYYY")
    Else
        Call ao_detailData.Add("Z_Creation", Format(Now, "DD/MM/YYYY"))
    End If
    Call Item_LoadValues(ao_detailData)
    
    Call UpdateUI(ArmScreenMode.smAdd)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddInit")
End Sub

' initialize update mode
Private Sub Item_UpdateInit(ByRef ao_detailData As Dictionary)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(ArmScreenMode.smUpdate)
    Call Item_Clear
    
    If ao_detailData("change") <> "A" Then ao_detailData("change") = "U"
    
    Call Item_LoadValues(ao_detailData)
    
    Call UpdateUI(ArmScreenMode.smUpdate)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateInit")
End Sub

' deletes item
Private Sub Item_Delete()
On Error GoTo ErrHandler
    
    If SendMessage("Delete record ?", vbQuestion + vbYesNo) = vbYes Then
    
        RaiseEvent OnItemDelete(Array(txt_Key.Text))

        Call Item_Exit
        
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Delete")
End Sub

' workw with smView, smUpdate and smDelete mode
Private Sub Item_Restore(ByRef as_detailData As Dictionary)
On Error GoTo ErrHandler
    ' clearing form
    Call ResetScreen(activeScreenMode)
    Call Item_Clear
    
    Call Item_LoadValues(as_detailData)
    Call UpdateUI

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Restore")
End Sub

' adds current edited item
Private Sub Item_Add()
On Error GoTo ErrHandler

    ' check values and throw message if neccessary
    If Not Item_Check() Then
        Exit Sub
    End If
    
    RaiseEvent OnItemAdd(Build_SrzString(UserControl.Controls, Me) & "change" & SEP1 & mo_dataSrc("change") & SEP & "iConcurrency" & SEP1 & "0")

    Call Item_Exit
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Add")
End Sub

' update current edited item
Private Sub Item_Update()
On Error GoTo ErrHandler
    If Not Item_Check() Then
        Exit Sub
    End If
    
    Dim lb_UpdateOK As Boolean
    RaiseEvent OnItemUpdate(Build_SrzString(UserControl.Controls, Me) & "change" & SEP1 & mo_dataSrc("change"), "U", lb_UpdateOK)
    
    If lb_UpdateOK Then Call Item_Exit

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Update")
End Sub

Private Sub Item_TransferAction(ByVal as_origOperatorCode As String, ByVal as_origOperatorDesc As String)
On Error GoTo ErrHandler
    If Not Item_Check() Then
        Exit Sub
    End If
    ' save current data for creation of the new action after curent one is updated
    mo_dataSrc.Item("User_Assigned") = pck_operator.ItemCode
    mo_dataSrc.Item("User_Assigned_Name") = pck_operator.ItemDescription
    mo_dataSrc.Item("SRAS_Id") = cbo_Status.SelectedItem.Key
    mo_dataSrc.Item("SRAS_Desc") = cbo_Status.SelectedItem.DisplayText
    
    ' set current action as completed
    Call SetComboBoxText(cbo_Status, eSRM_ActionStatus.SRAS_Completed, GetSRMActionStatusDesc(SRAS_Completed))
    ' update operator to original
    pck_operator.ItemCode = as_origOperatorCode
    pck_operator.ItemDescription = as_origOperatorDesc

    Dim lb_UpdateOK As Boolean
    RaiseEvent OnItemUpdate(Build_SrzString(UserControl.Controls, Me) & "change" & SEP1 & mo_dataSrc.Item("change"), "T", lb_UpdateOK)
    
    ' move to add new action screen
    Call ClearData(mo_dataSrc, Array("SRA_Id", "change", "PrevActionComment", _
                                    "SRT_Id", "MFGP_name", "SV_Id", "SVC_Id", "VC_Name", _
                                    "SRT_Summary", "SRT_Description", _
                                    "User_Assigned", "User_Assigned_Name", _
                                    "SRAS_Id", "SRAS_Desc"))
    ' update necessary data
    Dim ls_nextID As String
    ls_nextID = "NEW#1"
    RaiseEvent GetNextFreeID(ls_nextID)     ' event must be handled and provide next free ID
    mo_dataSrc.Item("SRA_Id") = ls_nextID
    mo_dataSrc.Item("change") = "A"
    mo_dataSrc.Item("PrevActionComment") = txt_Comment.Text
    Call Item_AddInit(mo_dataSrc)
    
    RaiseEvent OnItemAdd(Build_SrzString(UserControl.Controls, Me) & "change" & SEP1 & mo_dataSrc("change") & SEP & "iConcurrency" & SEP1 & "0")
   
    Call Item_Exit

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_TransferAction")
End Sub

Private Sub ClearData(ByRef ao_data As Dictionary, aa_exceptions As Variant)
On Error GoTo ErrHandler
    Dim ll_i As Long
    Dim lv_Keys As Variant
    lv_Keys = ao_data.keys
    For ll_i = LBound(lv_Keys) To UBound(lv_Keys)
        If Not ContaintValue(aa_exceptions, lv_Keys(ll_i)) Then
            Call ao_data.Remove(lv_Keys(ll_i))
        End If
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ClearData")
End Sub

Private Function ContaintValue(ByRef aa_array As Variant, ByVal as_Value As String) As Boolean
On Error GoTo ErrHandler
    ContaintValue = False
    Dim ll_i As Long
    For ll_i = LBound(aa_array) To UBound(aa_array)
        If aa_array(ll_i) = as_Value Then
            ContaintValue = True
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ContaintValue")
End Function



Private Function Build_SrzString(ByRef aControls As Variant, ByRef aContainer As Object) As String
On Error GoTo ErrHandler
    Dim ls_SrzString As String
    Dim lo_Control As CheckBox
    Dim lIdx As Long, lCount As Long
    
    Dim lValues As Variant
    Dim ls_TempTag As String
    Dim ls_Str As String
    Dim lControl As Control
   
    
        lCount = aControls.Count - 1
        ls_SrzString = ""
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) And lControl.Tag <> "" Then
                
                ls_TempTag = lControl.Tag & SEP
                lValues = Split(ls_TempTag, SEP)
                
                Select Case UCase(TypeName(lControl))
                    Case "TEXTBOX"
                            Select Case lValues(1)
                                Case "Text", "Date"
                                    ls_SrzString = ls_SrzString & lValues(0) & SEP1 & lControl.Text & SEP
                                Case "Num"
                                    ls_Str = Replace(lControl.Text, ms_ThousandSeparator, "")
                                    ls_Str = Replace(ls_Str, ms_DecimalSeparator, ".")
                                    ls_SrzString = ls_SrzString & lValues(0) & SEP1 & ls_Str & SEP
                           End Select
                    
                    Case "ARMCOMBOBOX"
        
                        If Not lControl.SelectedItem Is Nothing Then
                            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & lControl.SelectedItem.Key & SEP
                            ls_SrzString = ls_SrzString & lValues(1) & SEP1 & lControl.SelectedItem.GetData(1) & SEP
                        Else
                            ls_SrzString = ls_SrzString & lValues(0) & SEP1 & "NULL" & SEP
                            ls_SrzString = ls_SrzString & lValues(1) & SEP1 & "" & SEP
                        End If
                    Case "OPTIONBUTTON"
                        
                    Case "CHECKBOX"
                    Dim a As CheckBox
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & IIf(lControl.Value = vbChecked, "X", "") & SEP

                    Case "A_CALOCX"
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & lControl.date_courte & SEP
                        
                        
                    Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL"
                        'Do Nothing
                    
                    Case "ARMGRID"
                    
                    Case "ARMPICKER"
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & lControl.ItemCode & SEP
                        ls_SrzString = ls_SrzString & lValues(1) & SEP1 & lControl.ItemDescription & SEP
                    
                    Case Else
                        Debug.Print "Build_SrzString  -> " & UCase(TypeName(lControl))
                End Select
            End If
            Set lControl = Nothing
        Next

    ls_SrzString = Trim(ls_SrzString)
    Build_SrzString = ls_SrzString
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("Build_SrzString")
End Function

Private Sub FillDataSrcArray(ByRef ao_dataSrc As Dictionary, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim ll_i As Long
    Dim lsa_DataFields() As String
    Dim lv_Values As Variant
    Call ao_dataSrc.RemoveAll
    lsa_DataFields = Split(as_SrzFields, SEP)
    
    For ll_i = LBound(lsa_DataFields) To UBound(lsa_DataFields)
        lv_Values = Split(lsa_DataFields(ll_i), SEP1)
        If UBound(lv_Values) >= 1 Then
            If Not ao_dataSrc.Exists(lv_Values(0)) Then Call ao_dataSrc.Add(lv_Values(0), lv_Values(1))
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("FillDataSrcArray")
End Sub

Private Sub SetCheckBoxDB(ByVal al_cursor As Long, ByVal as_keyField As String, ByRef ao_CheckBox As VB.CheckBox, Optional ByVal as_checked As String = "X")
On Error GoTo ErrHandler
    Dim lv_val As Variant
    lv_val = mo_Db.GetFields(al_cursor, as_keyField)
    If Not IsEmpty(lv_val) Then
        ao_CheckBox.Value = IIf(lv_val = as_checked, vbChecked, vbUnchecked)
    Else
        ao_CheckBox.Value = vbUnchecked
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetCheckBoxDB")
End Sub


Private Sub SetComboBoxTextDB(ByVal al_cursor As Long, ByVal as_keyField As String, ByVal as_DescField As String, ByRef ao_Combobox As ArmCombobox, Optional ByVal ab_clearIfNotExists As Boolean = True)
On Error GoTo ErrHandler
    Dim lv_val As Variant
    lv_val = mo_Db.GetFields(al_cursor, CVar(Array(as_keyField, as_DescField)))
    If Not IsEmpty(lv_val) Then
        Debug.Assert (UBound(lv_val) = 1)
        Call SetComboBoxText(ao_Combobox, CStr(lv_val(0)), CStr(lv_val(1)))
    Else
        If ab_clearIfNotExists Or mo_Db.GetFieldIndex(al_cursor, as_keyField) <> -1 Then
            Call ao_Combobox.Clear
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetComboBoxTextDB")
End Sub

' Sets combobox selected item
' Params:
' ao_ComboBox (ArmCombobox)
' as_Key (String)
' as_Desc (String)
Private Sub SetComboBoxText(ByRef ao_Combobox As ArmCombobox, ByVal as_Key As String, ByVal as_Desc As String)
On Error GoTo ErrHandler
    If Not ao_Combobox.SearchItem(as_Key) Then
        ' key not found ... set value from parameter
        If as_Key = "" Or as_Key = "0" Then     ' zero or empty string is not valid key
            Set ao_Combobox.SelectedItem = Nothing
        Else
            Call ao_Combobox.AddItem(Array(as_Key, as_Desc), True)
            ' to make vb raise event
            Call ao_Combobox.SearchItem(as_Key)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SetComboBoxText")
End Sub

' exits mode to main
Private Sub Item_Exit()
On Error GoTo ErrHandler
    
    ' pop last item in screen mode stack
    Call popScreenModeUntil(smMain)
    
    Call ResetScreen(activeScreenMode)
    Call UpdateUI
    
    RaiseEvent OnExit
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ExitToGrid")
End Sub

Private Function Item_Check() As Boolean
On Error GoTo ErrHandler
        
    Dim lv_MsgReplaceInfo(0, 1) As String
    Dim lo_Control As Object
    Dim ls_LabelCaption As String
    Dim ll_CtrlIndex As Long
    Dim lb_Found As Boolean
    Dim lo_mandatoryField As Variant
    
    If Not IsArray(moa_ListFieldsMandatory) Then
        Item_Check = True
        Exit Function
    End If
    
    For Each lo_mandatoryField In moa_ListFieldsMandatory
        Set lo_Control = lo_mandatoryField(0)
        If lo_mandatoryField(1) >= 0 Then
            ls_LabelCaption = lbl_Label(lo_mandatoryField(1)).Caption
        Else
            ls_LabelCaption = ""
        End If
        Select Case UCase(TypeName(lo_Control))
            Case "FRAME", "LABEL", "MSFLEXGRID", "TOOLBARCONTROL"
                ' Do nothing !
            
            Case "TEXTBOX"
                If lo_Control.Visible And (lo_Control.Text = "") Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    lo_Control.SetFocus
                    Exit Function
                End If
            Case "ARMCHECKVIEW"
                 If lo_Control.Visible And (lo_Control.RoleList("EDIT").CheckedCount = 0) Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    Call lo_Control.SetFocus
                    Exit Function
                  End If
            Case "ARMGRID", "ARMCHECKVIEW", "COMMANDBUTTON", "A_CALOCX", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TABSTRIP"
            Case "OPTIONBUTTON", "CHECKBOX"
                'probably array of controls
            Case "OBJECT"
                lb_Found = False
                For ll_CtrlIndex = 0 To lo_Control.Count - 1
                    If UCase(TypeName(lo_Control(ll_CtrlIndex))) = "CHECKBOX" Then
                        If lo_Control(ll_CtrlIndex).Value = vbChecked Then
                            lb_Found = True
                            Exit For
                        End If
                    ElseIf UCase(TypeName(lo_Control(ll_CtrlIndex))) = "OPTIONBUTTON" Then
                        If lo_Control(ll_CtrlIndex).Value Then
                            lb_Found = True
                            Exit For
                        End If
                    Else
                        ' unknown array ???
                        lb_Found = True
                        Exit For
                    End If
                Next
                If Not lb_Found Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    Exit Function
                End If
            Case "ARMCOMBOBOX"
                If lo_Control.Visible And (lo_Control.SelectedItem Is Nothing) Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    Call lo_Control.SetFocus
                    Exit Function
                End If
            Case "ARMPICKER"
                If lo_Control.Visible And (CStr(lo_Control.ItemCode) = "") Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    lo_Control.SetFocus
                    Exit Function
                End If
            Case "LISTVIEW"
                 If lo_Control.Visible And (GetCheckedCount(lo_Control) = 0) Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = ls_LabelCaption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    Call lo_Control.SetFocus
                    Exit Function
                  End If
            Case Else
                Debug.Print "Item_CheckMandatory " & UCase(TypeName(lo_Control))
        End Select
    Next

    If ms_UserAssignedEmail = "" Then
        Call MsgBox(MsgText(7551, ms_Language_Code, "#Undefined email address for Assigned Operator. U_Code = ") & pck_operator.ItemCode)
        Call pck_operator.SetFocus
        Exit Function
    End If
    
    Item_Check = True

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Check")
End Function

Private Function GetCheckedCount(ByRef ao_ListView As MSComctlLib.ListView) As Long
On Error GoTo ErrHandler

Dim lo_item As MSComctlLib.ListItem
Dim ll_Count As Long

    ll_Count = 0
    For Each lo_item In ao_ListView.ListItems
        If lo_item.Checked Then ll_Count = ll_Count + 1
    Next
    GetCheckedCount = ll_Count
    Exit Function
ErrHandler:
    Call ErrorHandler("GetCheckedCount")
End Function

Private Sub SetFocusToCtrl(ByRef ao_ctrl As Object)
On Error GoTo ErrHandler
    If ao_ctrl.Visible Then
        ao_ctrl.SetFocus
    End If
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".SetFocusToCtrl")
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".LockScreen")
End Sub

Private Sub ResetScreen(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler
    ' apply face
    Dim lo_ctrl As Object

    Select Case au_Mode
        Case smMain
            ' enable filtering a browsing
            Call SetEnabled(GetContainedControlsChain(fra_detail), False)
            
        Case smUpdate, smAdd
            ' we are in Update section
            Call SetEnabled(GetContainedControlsChain(fra_detail), True)
            
            
            Dim lIdx As Long, lCount As Long
            
            If IsArray(moa_ListFieldsToDisable) Then
                lCount = UBound(moa_ListFieldsToDisable)
            
                For lIdx = 0 To lCount
                    Call SetEnabledCtrl(moa_ListFieldsToDisable(lIdx), False)
                Next
            End If
            
        Case smDelete, smView
            ' we are in PreView section
            Call SetEnabled(GetContainedControlsChain(fra_detail), False)
        Case Else
            Debug.Assert (False)
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ResetScreen()")
End Sub


Private Function HasContainer(ByRef aControl As Control, ByRef aContainer As Object) As Boolean
    HasContainer = False
    Dim lControl As Control
 
    Set lControl = aControl
    While Not (lControl Is Nothing)
        On Error GoTo NotFound
        If lControl.Container Is aContainer Then
            Set lControl = Nothing
            HasContainer = True
            Exit Function
        End If
        Set lControl = lControl.Container
    Wend
 
NotFound:
    Set lControl = Nothing
    HasContainer = False
End Function
 
Private Function IsSub(ByVal av_Name As Object, ByRef aav_Names As Variant)
On Error GoTo ErrHandler
    IsSub = False
    
    Dim ll_Idx As Long
    For ll_Idx = LBound(aav_Names) To UBound(aav_Names)
    
        If av_Name Is aav_Names(ll_Idx) Then
            IsSub = True
            Exit Function
        End If
    Next ll_Idx
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsSub")
End Function

' Clear values for each control to not initiliazed
Private Sub ClearForm(ByRef aControls As Variant, ByRef aContainer As Object, Optional ByRef aav_Except As Variant)
On Error GoTo ErrHandler
 
    'mb_internal = True
 
    Dim lIdx As Long, lCount As Long, lControl As Object
    lCount = aControls.Count - 1
    For lIdx = 0 To lCount
        Dim lb_Process As Boolean
        lb_Process = True
        Set lControl = aControls.Item(lIdx)
        If Not IsMissing(aav_Except) Then
            If IsSub(lControl, aav_Except) Then
                lb_Process = False
            End If
        End If
        If HasContainer(lControl, aContainer) And lb_Process Then
            Select Case UCase(TypeName(lControl))
                Case "TEXTBOX"
                    lControl.Text = ""
                Case "ARMCOMBOBOX"
'                    Set lControl.SelectedItem = Nothing
                    Call lControl.Clear
                Case "A_CALOCX"
                    lControl.reinit_cal
                Case "CHECKBOX"
                    lControl.Value = vbUnchecked
                Case "ARMCHECKVIEW"
                    lControl.UnCheckAll lControl.GetVisibleList
                    Dim ll_Idx As Long
                    For ll_Idx = 1 To lControl.RoleCount
                        lControl.RoleList(ll_Idx).ClearList
                    Next
                    lControl.SetVisibleList lControl.GetVisibleList
                    
                Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON"
 
                Case "ARMGRID"
                    lControl.ClearGrid
                Case "LISTBOX"
                    lControl.ListIndex = -1
                Case "OPTIONBUTTON"
                    lControl.Value = False
                Case "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX", "TOOLBARCONTROL", "LINE"
                
                Case "ARMPICKER"
                    Call lControl.Clear
                
                Case Else
                    Debug.Print "ClearForm " & UCase(TypeName(lControl))
            End Select
        End If
 
        Set lControl = Nothing
    Next
 
   ' mb_internal = False
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ClearForm")
End Sub

' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1)
#End If
On Error GoTo ErrHandler
    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Call Err.Raise(CompFncFailed, "ao_Db.ExecuteSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_DB))
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            Call Err.Raise(SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ExecuteSQLSafe")
End Sub

#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If
On Error GoTo ErrHandler
    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Call Err.Raise(CompFncFailed, "ao_Db.OpenSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_DB))
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".OpenSQLSafe")
End Function

Private Function GetComboKey(ByVal ao_Combo As ArmCombobox) As String
On Error GoTo ErrHandler

    GetComboKey = ""
    If Not (ao_Combo.SelectedItem Is Nothing) Then
        GetComboKey = Trim(CStr(ao_Combo.SelectedItem.Key))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetComboKey")
End Function

Private Function SqlInt(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlInt = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlInt = CStr(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlInt")
End Function

Private Function SqlDbl(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDbl = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlDbl = Str(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDbl")
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlDate")
End Function

Private Function SQLStr(ByVal as_str As String, Optional ByVal al_MaxLen As Long = 8000) As String
On Error GoTo ErrHandler
    SQLStr = "'" & Replace(Left(as_str, IIf(Len(as_str) <= al_MaxLen, Len(as_str), al_MaxLen)), "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SqlStr")
End Function

' safe retieving selected item from combobox
Private Function SQLComboBoxValue(ByRef ao_Combobox As ArmCombobox, Optional ByVal as_DefaultValue As String = "NULL", Optional ByVal ab_KeyTitle As Boolean = True) As String
On Error GoTo ErrHandler
    If IsComboboxSelected(ao_Combobox) Then
        SQLComboBoxValue = "'" & IIf(ab_KeyTitle, ao_Combobox.SelectedItem.Key, ao_Combobox.SelectedItem.DisplayText) & "'"
    Else
        SQLComboBoxValue = as_DefaultValue
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLComboBoxValue")
End Function

Private Function SQLOptionButtonValue(ByRef ao_options As Object) As String
On Error GoTo ErrHandler
    SQLOptionButtonValue = ""
    Dim opt_obj As OptionButton
    For Each opt_obj In ao_options
        If opt_obj.Value Then
            SQLOptionButtonValue = opt_obj.Tag
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLOptionButtonValue")
End Function

Private Function IsComboboxSelected(ByRef as_combo As ArmCombobox) As Boolean
On Error GoTo ErrHandler
    IsComboboxSelected = False
    If Not as_combo.SelectedItem Is Nothing Then
        If Not IsEmpty(as_combo.SelectedItem.Key) Then
            IsComboboxSelected = True
        End If
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsComboboxSelected")
End Function

' ************************************************************************************

' ************************************************************************************
' **************************** REDIM FUNCTION ****************************************
' ************************************************************************************
Sub SafeRedimString(ByRef as_Array() As String, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim as_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(as_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedimString()")
End Sub

Sub SafeRedim(ByRef av_Array() As Variant, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim av_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(av_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedim()")
End Sub
' **************************** REDIM FUNCTION ****************************************

' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
#If LIVE = 1 Then
Private Function GetDbError(ByVal lo_Db As Object) As String
#Else
Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
#End If
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetDbError()")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    If Err.Number = QuietException Then Exit Sub
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    
    Call LogMessage(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_errDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT" & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, , "Error message: " & as_Fct)
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.")
    MsgText = aDefault
End Function

Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "EXEC A_log_ins $UCODE$, $LOGTYPE$, $MSG$, $APP$"
    Dim ls_req As String
    Dim ll_cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_U_Code))
    ls_req = Replace(ls_req, "$APP$", SQLStr(C_APPNAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision, 50))
    ls_req = Replace(ls_req, "$MSG$", SQLStr(as_logMsg, 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler(Extender.Name & ".LogMessage()")
End Sub

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Function SendMessage(ByVal as_msg As String, Optional Buttons As VbMsgBoxStyle = vbOKOnly) As VbMsgBoxResult
On Error GoTo ErrHandler
    Call LockScreen(True)
    SendMessage = MsgBox(as_msg, Buttons)
    Call LockScreen(False)
    Exit Function
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".SendMessage")
End Function

' function return original container
Private Function MoveControlToFront(ByRef ao_ctrl As Object) As Object
On Error GoTo ErrHandler
    Set MoveControlToFront = ao_ctrl.Container
    ao_ctrl.Top = ao_ctrl.Container.Top + ao_ctrl.Top
    ao_ctrl.Left = ao_ctrl.Container.Left + ao_ctrl.Left
    Set ao_ctrl.Container = ao_ctrl.Container.Container
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".MoveControlToFront")
End Function

' recalculate position correctly only in case of one level hierachical change
Private Function MoveControlToFrame(ByRef ao_ctrl As Object, ByRef ao_Frame As VB.Frame) As Object
On Error GoTo ErrHandler
    Set MoveControlToFrame = ao_ctrl.Container
    Set ao_ctrl.Container = ao_Frame
    ao_ctrl.Top = ao_ctrl.Top - ao_Frame.Top
    ao_ctrl.Left = ao_ctrl.Left - ao_Frame.Left
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".MoveControlToFrame")
End Function

' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_cursor As Long
    Dim ll_codePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_cursor <> 0 Then Call ao_Armdb.Close(ll_cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)
On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub

ErrHandler:
    Call ErrorHandler(Extender.Name & ".ChangeCharset")
End Sub


Private Function ReplacePlaceholderByControlValue(ByVal as_Request As String, ByRef ao_Control As Object) As String
On Error GoTo ErrHandler

Dim lsa_Columns() As String

    If Trim(ao_Control.Tag) = "" Then
        ReplacePlaceholderByControlValue = as_Request
        Exit Function
    End If
    
    Select Case UCase(TypeName(ao_Control))
        Case "ARMCOMBOBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If GetComboKey(ao_Control) = "" Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(GetComboKey(ao_Control)))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(ao_Control.Text))
            End If
        Case "ARMPICKER"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If (Trim(CStr(ao_Control.ItemCode)) = "") Or (CStr(ao_Control.ItemCode) = "0") Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(Trim(CStr(ao_Control.ItemCode))))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(Trim(ao_Control.ItemDescription)))
            End If
        Case "CHECKBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.Value = vbChecked Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr("X"))
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(""))
            End If
        Case "TEXTBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If UBound(lsa_Columns) > 0 Then
                
                Select Case lsa_Columns(1)
                    Case "Text"
                        as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
                    Case "Num"
                        If ao_Control.Text = "" Then
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "0")
                        Else
                            Dim ls_number As String
                            ls_number = Replace(Trim(ao_Control.Text), ms_ThousandSeparator, "", , , vbTextCompare)
                            ls_number = Replace(ls_number, ms_DecimalSeparator, ".", , , vbTextCompare)
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", ls_number)
                        End If
                    Case "Date"
                        If Not IsDate(ao_Control.Text) Then
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                        Else
                            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(CDate(ao_Control.Text)))
                        End If
                End Select
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
            End If
        Case "A_CALOCX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(ao_Control.date_dt))
        Case "TABSTRIP"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.SelectedItem Is Nothing Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.SelectedItem.Key))
            End If
    End Select
    ReplacePlaceholderByControlValue = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholderByControlValue")
End Function

Private Function ReplaceRequestByFrameData(ByVal as_Request As String, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control
   
    For Each lo_Control In UserControl.Controls
        If HasContainer(lo_Control, ao_Frame) Then
            as_Request = ReplacePlaceholderByControlValue(as_Request, lo_Control)
        End If
    Next
    ReplaceRequestByFrameData = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceRequestByFrameData")
End Function

Private Function GetArrayItem(ByVal as_serialStr As String, ByVal as_Key As String) As String
On Error GoTo ErrHandler
    Dim lsa_fullData() As String
    Dim lsa_item    As Variant
    Dim ll_i As Long
    GetArrayItem = ""
    lsa_fullData = Split(as_serialStr, SEP)
    For ll_i = LBound(lsa_fullData) To UBound(lsa_fullData)
        lsa_item = Split(lsa_fullData(ll_i), SEP1)
        If UBound(lsa_item) >= 1 Then
            If StrComp(as_Key, lsa_item(0), vbTextCompare) = 0 Then
                GetArrayItem = lsa_item(1)
                Exit Function
            End If
        End If
    Next
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetArrayItem")
End Function

Private Sub cmd_addVendorContact_Click()
On Error GoTo ErrHandler
    ' Want to Add
    Call InitVendorContact
    ' load detail
    
    If Not mo_SRM_VendorContact Is Nothing Then
        ' must add current vendor into grid of vendors for the new contact
        Call mo_SRM_VendorContact.Run(SRM_Mode.emAdd, Array(""))
        Call mo_SRM_VendorContact.ImportVendorsGridData(Join(Array(Join(Array("SV_Id", mo_dataSrc.Item("SV_Id")), SEP1), _
                                                                    Join(Array("SV_Name", mo_dataSrc.Item("SV_Name")), SEP1), _
                                                                    Join(Array("SV_City", mo_dataSrc.Item("SV_City")), SEP1), _
                                                                    Join(Array("change", "A"), SEP1)), _
                                                            SEP))
        Call UpdateUISubDetail(smSubVendorContact)
    End If

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".cmd_addVendorContact_Click")
End Sub

Private Sub mo_SRM_Attachment_OnExit()
On Error GoTo ErrHandler
    
    Call UpdateUISubDetail(smMain)

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SRM_Attachment_OnExit")
End Sub

Private Sub mo_SRM_Attachment_OnItemAdd(ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim lo_dataSrc As New Dictionary
    lo_dataSrc.CompareMode = TextCompare
    
    Call FillDataSrcArray(lo_dataSrc, as_SrzFields)
    
    Call AddLineToGrid(grd_Attachment, lo_dataSrc)

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SRM_Attachment_OnItemAdd")
End Sub

Private Sub mo_SRM_Attachment_OnItemDelete(ByVal av_Key As Variant)
On Error GoTo ErrHandler
    
    Call DeleteLineToGrid(grd_Attachment, Array("SRAA_Id"), av_Key)

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SRM_Attachment_OnItemDelete")
End Sub

Private Sub mo_SRM_Attachment_OnItemUpdate(ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    Dim lo_dataSrc As New Dictionary
    lo_dataSrc.CompareMode = TextCompare
    
    Call FillDataSrcArray(lo_dataSrc, as_SrzFields)
    
    Call UpdateLineToGrid(grd_Attachment, lo_dataSrc, Array("SRAA_Id"))

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SRM_Attachment_OnItemUpdate")
End Sub

Private Sub mo_SRM_VendorContact_OnExit()
On Error GoTo ErrHandler
    
    Call UpdateUISubDetail(smMain)

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SRM_VendorContact_OnExit")
End Sub

Private Sub mo_SRM_VendorContact_OnItemAdd(ByVal av_Key As Variant, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    Dim lo_dataSrc As New Dictionary
    lo_dataSrc.CompareMode = TextCompare
    
    Call FillDataSrcArray(lo_dataSrc, as_SrzFields)

    ' add line to combobox and select it
    Call SetComboBoxText(cbo_VenContact, av_Key(0), lo_dataSrc.Item("FirstName") & " " & lo_dataSrc.Item("LastName"))
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SRM_VendorContact_OnItemAdd")
End Sub

Private Sub pck_operator_ItemPicked()
On Error GoTo ErrHandler
    If mb_Initializing Then Exit Sub
    Call LockScreen(True)
    
    Dim lo_searchFrm As frmSearchSRM
    
    Set lo_searchFrm = New frmSearchSRM
    
    lo_searchFrm.Language_Code = ms_Language_Code
    Set lo_searchFrm.ArmDb = mo_Db
    lo_searchFrm.SearchType = SRM_CompType.SRCT_User
    Call lo_searchFrm.Load_A_COM

    Screen.MousePointer = vbDefault
    Call lo_searchFrm.show(vbModal)
    If lo_searchFrm.mb_SearchOK = True Then
        
        Dim lo_dataSrc As New Dictionary
        lo_dataSrc.CompareMode = TextCompare
        Call FillDataSrcArray(lo_dataSrc, lo_searchFrm.mo_search.SelectedItemFull)
        
        If lo_dataSrc.Item("U_Email_Armstrong") = "" Then
            Call MsgBox(MsgText(7551, ms_Language_Code, "#Undefined email address for Assigned Operator. U_Code = ") & lo_searchFrm.mo_search.SelectedItemCode)
            Call pck_operator.SetFocus
        Else
        
            ms_UserAssignedEmail = lo_dataSrc.Item("U_Email_Armstrong")
            
            pck_operator.ItemCode = lo_searchFrm.mo_search.SelectedItemCode
            pck_operator.ItemDescription = lo_dataSrc.Item("P_First_Name") & " " & lo_dataSrc.Item("P_Name")
        
        End If
        
        Set lo_dataSrc = Nothing
        Call UpdateMainToolbar
    End If
    Call lo_searchFrm.Unload_A_COM
    Set lo_searchFrm = Nothing

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage(Extender.Name & ".pck_operator_ItemPicked")
End Sub

Private Sub tlb_Attachment_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tlb_Attachment.Enabled = False


    Select Case as_Role
        Case "A"
            ' Want to Add
            Call InitTaskAttachment
            ' load detail
            
            If Not mo_SRM_Attachment Is Nothing Then
                Call mo_SRM_Attachment.Run(SRM_Mode.emAdd, Join(Array( _
                                                                    Join(Array("SRAA_Id", "NEW#" & (GetGridColMaxValue(grd_Attachment, "SRAA_Id", "NEW#") + 1)), SEP1), _
                                                                    Join(Array("Z_Creation", Format(Now, "DD/MM/YYYY")), SEP1), _
                                                                    Join(Array("Z_Creator_Name", ms_LoginName), SEP1), _
                                                                    Join(Array("change", "A"), SEP1) _
                                                                ), SEP))
                Call UpdateUISubDetail(smSubAttachement)
            End If
        Case "B"
            If grd_Attachment.SelectedCount > 0 Then
                If grd_Attachment.CurrentLine("change") <> "D" Then
                    ' Want to Update
                    Call InitTaskAttachment
                    ' load detail
                    If Not mo_SRM_Attachment Is Nothing Then
                        Call mo_SRM_Attachment.Run(SRM_Mode.emUpdate, Join(Array( _
                                                                        Build_SrzStringFromGridLine(grd_Attachment) _
                                                                    ), SEP))
                        Call UpdateUISubDetail(smSubAttachement)
                    End If
                Else
                    MsgBox MsgText(ErrMsgItemIsDeleted, ms_Language_Code, "#Row is deleted."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                End If
            Else
                MsgBox MsgText(WarMsgSelectRow, ms_Language_Code, "#Please select a row."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            End If
        Case "C"
            If grd_Attachment.SelectedCount > 0 Then
                If grd_Attachment.CurrentLine("change") <> "D" Then
                    ' Want to delete
                    Call InitTaskAttachment
                    ' load detail
                    If Not mo_SRM_Attachment Is Nothing Then
                        Call mo_SRM_Attachment.Run(SRM_Mode.emDelete, Build_SrzStringFromGridLine(grd_Attachment))
                    End If
                Else
                    MsgBox MsgText(ErrMsgItemIsDeleted, ms_Language_Code, "#Row is deleted."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                End If
            Else
                MsgBox MsgText(WarMsgSelectRow, ms_Language_Code, "#Please select a row."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
            End If
        Case Else
            Err.Raise ArmErr.InvalidArgument, "tlb_Product_action", "Unknown main toolbar role as_Role=" & as_Role
    End Select

    tlb_Attachment.Enabled = True
    
    Call LockScreen(False)
    
    DoCheck = False

    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    tlb_Attachment.Enabled = True
    Call LockScreen(False)
    
    Call LogMessage("tlb_Attachment_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    Exit Sub
End Sub

Private Sub tlb_main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tlb_Main.Enabled = False

    Select Case as_Role
        Case "I" 'Refresh update
            Call Item_Restore(mo_dataSrc)
            
        Case "H" 'validate mode add
            Select Case activeScreenMode
                Case ArmScreenMode.smAdd
                    Call Item_Add
                Case ArmScreenMode.smUpdate
                    If ms_oldOperatorCode = pck_operator.ItemCode Then
                        Call Item_Update
                    Else    ' close current action and create new
                        Call Item_TransferAction(ms_oldOperatorCode, ms_oldOperatorDesc)
                    End If
                Case ArmScreenMode.smDelete
                    Call Item_Delete
                Case Else
                    Debug.Assert (False)
            End Select
        
        Case "T"
            Call Item_Exit
    End Select
    
    tlb_Main.Enabled = True
    
    Call LockScreen(False)
    
    DoCheck = False

    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    tlb_Main.Enabled = True
    Call LockScreen(False)
    
    Select Case Err.Number
    Case 3007
        MsgBox MsgText(3054, ms_Language_Code, "#This data has been updated by another user. Please reload the data and try again."), vbInformation
    
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call Item_Exit
    
    Case Else
        Call LogMessage("tlb_Main_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select

    Exit Sub
End Sub

Public Sub ImportAttachmentGrid(ByRef ao_srcGrid As ArmGrid)
On Error GoTo ErrHandler
    Call CopyGridData(ao_srcGrid, grd_Attachment)
    Exit Sub
ErrHandler:
    Call ErrorMessage("ImportAttachmentGrid")
End Sub

Public Sub ExportAttachmentGrid(ByRef ao_dstGrid As ArmGrid)
On Error GoTo ErrHandler
    Call CopyGridData(grd_Attachment, ao_dstGrid)
    Exit Sub
ErrHandler:
    Call ErrorMessage("ImportAttachmentGrid")
End Sub

Private Sub CopyGridData(ByRef ao_srcGrid As ArmGrid, ByRef ao_destGrid As ArmGrid)
On Error GoTo ErrHandler
    Call ao_destGrid.ClearGrid
    
    ' copy data
    Dim ll_Row As Long
    Dim ll_Col As Long
    ao_destGrid.Rows = ao_srcGrid.Rows
    For ll_Row = 0 To ao_srcGrid.Rows - 1
        For ll_Col = 0 To ao_destGrid.Cols - 1
            ao_destGrid.Data(ll_Row, ll_Col) = ao_srcGrid.Data(ll_Row, ao_destGrid.Columns(ll_Col).Name)
        Next
        ao_destGrid.LineColor(ll_Row) = ao_srcGrid.LineColor(ll_Row)
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler("CopyGrid")
End Sub

Private Function GetGridColMaxValue(ByRef ao_grid As ArmGrid, ByVal as_colName As String, ByVal as_like As String) As Long
On Error GoTo ErrHandler
    Dim ll_Row As Long
    Dim ls_Data As String
    Dim ll_retVal As Long
    ll_retVal = 0
    For ll_Row = 0 To ao_grid.Rows - 1
        ls_Data = ao_grid.Data(ll_Row, as_colName)
        If Len(ls_Data) > Len(as_like) Then
            If StrComp(Left(ls_Data, Len(as_like)), as_like, vbTextCompare) = 0 Then
                ls_Data = right(ao_grid.Data(ll_Row, as_colName), Len(ao_grid.Data(ll_Row, as_colName)) - Len(as_like))
                If isNumeric(ls_Data) Then
                    If CLng(ls_Data) > ll_retVal Then ll_retVal = CLng(ls_Data)
                End If
            End If
        End If
    Next
    GetGridColMaxValue = ll_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetGridColMaxValue")
End Function

Private Function Build_SrzStringFromGridLine(ByRef ao_grid As Control, Optional ByVal al_Row As Long = -1) As String
On Error GoTo ErrHandler
    Dim ls_ret As String
    Build_SrzStringFromGridLine = ""
    If al_Row = -1 Then
        If ao_grid.SelectedCount > 0 Then
            al_Row = ao_grid.Row
        Else
            Call Err.Raise(ArmErr.InvalidArgument, "", "No row selected in grid.")
        End If
    End If
    
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        ls_ret = IIf(ll_Col = 0, "", ls_ret & SEP) & lo_Column.FieldName & SEP1 & lo_Column.GetData(al_Row)
    Next
    
    Build_SrzStringFromGridLine = ls_ret
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Build_SrzStringFromGridLine")
End Function

Private Sub AddLineToGrid(ByVal ao_grid As ArmGrid, ByRef ao_dataSrc As Dictionary, Optional ByVal ab_insertAtBeginning As Boolean = False)
On Error GoTo ErrHandler
    
    ' insert row at the end of grid
    Debug.Assert (ao_grid.Cols > 0)
    Dim lo_Column As ArmColumn
    Dim ll_Index As Long
    Dim lsa_newRow() As String
    ReDim lsa_newRow(0 To ao_grid.Cols - 1)
    
    Call ao_grid.DeselectRow
    
    For ll_Index = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Index)
        If ao_dataSrc.Exists(lo_Column.FieldName) Then
            lsa_newRow(ll_Index) = ao_dataSrc.Item(lo_Column.FieldName)
        Else
            lsa_newRow(ll_Index) = "TODO:"
        End If
    Next
    
    If ab_insertAtBeginning Then
        Call ao_grid.InsertLine(0, lsa_newRow)
        Call ao_grid.FirstLine
    Else
        Call ao_grid.AddLine(lsa_newRow)
    End If
    ao_grid.LineColor(ao_grid.Row) = SRM_COLOR_ADDLINE
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("AddLineToGrid")
End Sub

Private Sub DeleteLineToGrid(ByVal ao_grid As ArmGrid, ByVal av_KeyFields As Variant, ByVal al_KeyVal As Variant)
On Error GoTo ErrHandler
    
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    Dim lba_bckKeys() As Boolean
    Dim lv_bckKey As Variant
    ReDim lba_bckKeys(0 To ao_grid.Cols - 1)
    
    ' backup keys
    lv_bckKey = ao_grid.CurrentKey
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        lba_bckKeys(ll_Col) = lo_Column.Key
        lo_Column.Key = IsInArray(lo_Column.FieldName, av_KeyFields)
    Next

    ' delete all lines
    ao_grid.FirstLine
    Do While ao_grid.SearchKey(False, al_KeyVal)
        If ao_grid.CurrentLine("change") = "A" Then
            ' if line is new then delete line
            ao_grid.DeleteLine
        Else
            ' line is not realy deletable
            ao_grid.CurrentLine("change") = "D"
            ao_grid.LineColor(ao_grid.Row) = SRM_COLOR_DELLINE
            If Not ao_grid.NextLine Then
                Exit Do
            End If
        End If
    Loop
    
    ' restore keys
    For ll_Col = 0 To ao_grid.Cols - 1
        ao_grid.Columns(ll_Col).Key = lba_bckKeys(ll_Col)
    Next
    Call ao_grid.SearchKey(True, lv_bckKey)

    Exit Sub
ErrHandler:
    Call ErrorHandler("DeleteLineToGrid")
End Sub

Private Sub UpdateLineToGrid(ByVal ao_grid As ArmGrid, ByRef ao_dataSrc As Dictionary, ByVal av_keyCols As Variant)
On Error GoTo ErrHandler

    Debug.Assert (ao_grid.Cols > 0)
    Dim ll_Row As Long, ll_RowCount As Long, ll_Col As Long
    Dim lo_Column As ArmColumn
    
    ll_RowCount = ao_grid.Rows - 1
    For ll_Row = 0 To ll_RowCount
        If IsKeyRow(ao_grid, ll_Row, av_keyCols, ao_dataSrc) Then
            For ll_Col = 0 To ao_grid.Cols - 1
                Set lo_Column = ao_grid.Columns(ll_Col)
                If ao_dataSrc.Exists(lo_Column.FieldName) Then
                    Call lo_Column.SetData(ll_Row, ao_dataSrc(lo_Column.FieldName))
                End If
            Next
            ao_grid.LineColor(ll_Row) = SRM_COLOR_UPDLINE
        End If
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateLineToGrid")
End Sub

Private Function IsInArray(ByVal as_val As String, ByRef av_Array As Variant) As Boolean
On Error GoTo ErrHandler
    Dim ll_i As Long
    IsInArray = False
    For ll_i = LBound(av_Array) To UBound(av_Array)
        If StrComp(av_Array(ll_i), as_val, vbTextCompare) <> 0 Then Exit Function
    Next
    IsInArray = True
    Exit Function
ErrHandler:
    Call ErrorHandler("IsInArray")
End Function

Private Function IsKeyRow(ByVal ao_grid As ArmGrid, ByVal al_Row As Long, ByVal av_keyCols As Variant, ByRef ao_dataSrc As Dictionary) As Boolean
On Error GoTo ErrHandler
    IsKeyRow = False
    Dim ll_i As Long
    For ll_i = LBound(av_keyCols) To UBound(av_keyCols)
        If StrComp(ao_grid.Data(al_Row, av_keyCols(ll_i)), ao_dataSrc(av_keyCols(ll_i)), vbTextCompare) <> 0 Then
            Exit Function
        End If
    Next
    IsKeyRow = True
    Exit Function
ErrHandler:
    Call ErrorHandler("IsKeyRow")
End Function

Private Function GetSRMActionStatusDesc(ByVal al_SRAS_Id As eSRM_ActionStatus) As String
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT SRAS_Desc FROM SRM_ActionStatus WHERE SRAS_Id=$SRAS_Id$ AND Language_Code=$Language_Code$"
    Dim ll_cursor As Long
    Dim ls_req As String
    
    ls_req = ReplaceCommonPlaceholders(C_REQ)
    ls_req = ReplacePlaceHolder(ls_req, "$SRAS_Id$", al_SRAS_Id)
    ll_cursor = OpenSQLSafe(mo_Db, ls_req, 1)
    
    GetSRMActionStatusDesc = mo_Db.GetFields(ll_cursor, "SRAS_Desc")
    Call mo_Db.Close(ll_cursor)
    
    Exit Function
ErrHandler:
    If ll_cursor > 0 Then
        Call mo_Db.Close(ll_cursor)
    End If
    Call ErrorHandler(Extender.Name & ".GetSRMActionStatusDesc")
End Function

Private Sub UpdateMainToolbar()
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".UpdateMainToolbar")
End Sub

